/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.ftbbackups.de.piegames.blockmap.world;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.io.gsonfire.annotations.ExposeMethodResult;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.org.joml.Vector2ic;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.org.joml.Vector3ic;

public abstract class ChunkMetadata {
    public final Vector2ic position;

    public ChunkMetadata(Vector2ic position) {
        this.position = Objects.requireNonNull(position);
    }

    @ExposeMethodResult(value="renderState")
    public abstract ChunkRenderState getRenderState();

    public abstract <T> T visit(ChunkMetadataVisitor<T> var1);

    public static class ChunkMetadataVersion
    extends ChunkMetadata {
        public final int version;
        public final String message;

        public ChunkMetadataVersion(Vector2ic position, String message, int version) {
            super(position);
            this.version = version;
            this.message = message;
        }

        @Override
        public ChunkRenderState getRenderState() {
            return ChunkRenderState.TOO_OLD;
        }

        @Override
        public <T> T visit(ChunkMetadataVisitor<T> visitor) {
            return visitor.version(this);
        }
    }

    public static class ChunkMetadataCulled
    extends ChunkMetadata {
        public ChunkMetadataCulled(Vector2ic position) {
            super(position);
        }

        @Override
        public ChunkRenderState getRenderState() {
            return ChunkRenderState.CULLED;
        }

        @Override
        public <T> T visit(ChunkMetadataVisitor<T> visitor) {
            return visitor.culled(this);
        }
    }

    public static class ChunkMetadataFailed
    extends ChunkMetadata {
        public final Exception error;

        public ChunkMetadataFailed(Vector2ic position, Exception error) {
            super(position);
            this.error = error;
        }

        @Override
        public ChunkRenderState getRenderState() {
            return ChunkRenderState.FAILED;
        }

        @Override
        public <T> T visit(ChunkMetadataVisitor<T> visitor) {
            return visitor.failed(this);
        }
    }

    public static class ChunkMetadataRendered
    extends ChunkMetadata {
        public static final Set<String> STATUS_EMPTY = Collections.singleton("empty");
        public static final Set<String> STATUS_FINISHED = Stream.of("full", "postprocessed").collect(Collectors.toUnmodifiableSet());
        public final String generationStatus;
        public final Map<String, Vector3ic> structures;

        public ChunkMetadataRendered(Vector2ic position, String generationStatus) {
            this(position, generationStatus, Collections.emptyMap());
        }

        public ChunkMetadataRendered(Vector2ic position, String generationStatus, Map<String, Vector3ic> structures) {
            super(position);
            this.generationStatus = Objects.requireNonNull(generationStatus);
            this.structures = Collections.unmodifiableMap(structures);
        }

        @Override
        public ChunkRenderState getRenderState() {
            return ChunkRenderState.RENDERED;
        }

        @Override
        public <T> T visit(ChunkMetadataVisitor<T> visitor) {
            return visitor.rendered(this);
        }
    }

    public static interface ChunkMetadataVisitor<T> {
        public T rendered(ChunkMetadataRendered var1);

        public T failed(ChunkMetadataFailed var1);

        public T culled(ChunkMetadataCulled var1);

        public T version(ChunkMetadataVersion var1);
    }

    public static enum ChunkRenderState {
        RENDERED(ChunkMetadataRendered.class),
        FAILED(ChunkMetadataFailed.class),
        CULLED(ChunkMetadataCulled.class),
        TOO_OLD(ChunkMetadataVersion.class);

        public final Class<? extends ChunkMetadata> clazz;

        private ChunkRenderState(Class<? extends ChunkMetadata> clazz) {
            this.clazz = clazz;
        }
    }
}

